rule Win32_Ransomware_Delphimorix : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DELPHIMORIX"
        description         = "Yara rule that detects Delphimorix ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Delphimorix"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {                        
            55 8B EC 83 C4 ?? 53 56 57 33 D2 89 55 ?? 89 45 ?? 8B 45 ?? E8 ?? ?? ?? ?? 33 C0 55 
            68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 6A ?? 8B 
            4D ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 68 ?? ?? ?? ?? 8D 45 ?? B9 ?? ?? ?? 
            ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 4D ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B C3 
            8B 10 FF 12 52 50 B9 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 
            C6 E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 EB ?? E9 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 
            ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB ?? 5F 5E 5B 59 59 5D C3 
        }

        $find_files_p1 = {                        
            55 8B EC 81 C4 ?? ?? ?? ?? 53 56 33 DB 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? 
            ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 8B D9 89 55 ?? 89 45 ?? 8B 45 ?? E8 ?? 
            ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 ?? E8 ?? ?? ?? ?? 8B 55 ?? 80 7C 02 
            ?? ?? 75 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B D0 4A 8D 45 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? 
            ?? ?? ?? FF 75 ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            8D 8D ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 8B D0 83 CA ?? 3B D0 75 ?? 80 FB ?? 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? BA ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 0F 84 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85
        }

        $find_files_p2 = {                        
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B CB 8B 55 ?? E8 ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B 
            C6 83 C8 ?? 3B C6 75 ?? 80 FB ?? 75 ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 74 ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 ?? FF 75 ?? 68 ?? ?? ?? 
            ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 8B CB 8B 55 ?? E8 ?? ?? ?? ?? EB ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($find_files_p*)
        ) and 
        (
            $encrypt_files
        )
}